# Equipment

## Armor

Fantasy gaming worlds are a vast tapestry made up of many different cultures, each with its own technology level. For this reason, adventurers have access to a variety of armor types, ranging from leather armor to chain mail to costly plate armor, with several other kinds of armor in between. The Armor table collects the most commonly available types of armor found in the game and separates them into three categories: light armor, medium armor, and heavy armor. Many warriors supplement their armor with a shield.

The Armor table shows the cost, weight, and other properties of the common types of armor worn in fantasy gaming worlds.

***Armor Proficiency***. Anyone can put on a suit of armor or strap a shield to an arm. Only those proficient in the armor's use know how to wear it effectively, however. Your class gives you proficiency with certain types of armor. If you wear armor that you lack proficiency with, you have disadvantage on any ability check, saving throw, or attack roll that involves Strength or Dexterity, and you can't cast spells.

***Armor Class (AC)***. Armor protects its wearer from attacks. The armor (and shield) you wear determines your base Armor Class.

***Heavy Armor***. Heavier armor interferes with the wearer's ability to move quickly, stealthily, and freely. If the Armor table shows "Str 13" or "Str 15" in the Strength column for an armor type, the armor reduces the wearer's speed by 10 feet unless the wearer has a Strength score equal to or higher than the listed score.

***Stealth***. If the Armor table shows "Disadvantage" in the Stealth column, the wearer has disadvantage on Dexterity (Stealth) checks.

***Shields***. A shield is made from wood or metal and is carried in one hand. Wielding a shield increases your Armor Class by 2. You can benefit from only one shield at a time.

### Light Armor

Made from supple and thin materials, light armor favors agile adventurers since it offers some protection without sacrificing mobility. If you wear light armor, you add your Dexterity modifier to the base number from your armor type to determine your Armor Class.

***Padded***. Padded armor consists of quilted layers of cloth and batting.

***Leather***. The breastplate and shoulder protectors of this armor are made of leather that has been stiffened by being boiled in oil. The rest of the armor is made of softer and more flexible materials.

***Studded Leather***. Made from tough but flexible leather, studded leather is reinforced with close-set rivets or spikes.

### Medium Armor

Medium armor offers more protection than light armor, but it also impairs movement more. If you wear medium armor, you add your Dexterity modifier, to a maximum of +2, to the base number from your armor type to determine your Armor Class.

***Hide***. This crude armor consists of thick furs and pelts. It is commonly worn by barbarian tribes, evil humanoids, and other folk who lack access to the tools and materials needed to create better armor.

***Chain Shirt***. Made of interlocking metal rings, a chain shirt is worn between layers of clothing or leather. This armor offers modest protection to the wearer's upper body and allows the sound of the rings rubbing against one another to be muffled by outer layers.

***Scale Mail***. This armor consists of a coat and leggings (and perhaps a separate skirt) of leather covered with overlapping pieces of metal, much like the scales of a fish. The suit includes gauntlets.

***Breastplate***. This armor consists of a fitted metal chest piece worn with supple leather. Although it leaves the legs and arms relatively unprotected, this armor provides good protection for the wearer's vital organs while leaving the wearer relatively unencumbered.

***Half Plate***. Half plate consists of shaped metal plates that cover most of the wearer's body. It does not include leg protection beyond simple greaves that are attached with leather straps.

### Heavy Armor

Of all the armor categories, heavy armor offers the best protection. These suits of armor cover the entire body and are designed to stop a wide range of attacks. Only proficient warriors can manage their weight and bulk.

Heavy armor doesn't let you add your Dexterity modifier to your Armor Class, but it also doesn't penalize you if your Dexterity modifier is negative.

***Ring Mail***. This armor is leather armor with heavy rings sewn into it. The rings help reinforce the armor against blows from swords and axes. Ring mail is inferior to chain mail, and it's usually worn only by those who can't afford better armor.

***Chain Mail***. Made of interlocking metal rings, chain mail includes a layer of quilted fabric worn underneath the mail to prevent chafing and to cushion the impact of blows. The suit includes gauntlets.

***Splint***. This armor is made of narrow vertical strips of metal riveted to a backing of leather that is worn over cloth padding. Flexible chain mail protects the joints.

***Plate***. Plate consists of shaped, interlocking metal plates to cover the entire body. A suit of plate includes gauntlets, heavy leather boots, a visored helmet, and thick layers of padding underneath the armor. Buckles and straps distribute the weight over the body.

**Table- Armor**

| Armor            | Cost     | Armor Class (AC)          | Strength | Stealth      | Weight |
|------------------|----------|---------------------------|----------|--------------|--------|
| **Light Armor**  |          |                           |          |              |        |
| Padded           | 5 gp     | 11 + Dex modifier         | -        | Disadvantage | 8 lb.  |
| Leather          | 10 gp    | 11 + Dex modifier         | -        | -            | 10 lb. |
| Studded leather  | 45 gp    | 12 + Dex modifier         | -        | -            | 13 lb. |
| **Medium Armor** |          |                           |          |              |        |
| Hide             | 10 gp    | 12 + Dex modifier (max 2) | -        | -            | 12 lb. |
| Chain shirt      | 50 gp    | 13 + Dex modifier (max 2) | -        | -            | 20 lb. |
| Scale mail       | 50 gp    | 14 + Dex modifier (max 2) | -        | Disadvantage | 45 lb. |
| Breastplate      | 400 gp   | 14 + Dex modifier (max 2) | -        | -            | 20 lb. |
| Half plate       | 750 gp   | 15 + Dex modifier (max 2) | -        | Disadvantage | 40 lb. |
| **Heavy Armor**  |          |                           |          |              |        |
| Ring mail        | 30 gp    | 14                        | -        | Disadvantage | 40 lb. |
| Chain mail       | 75 gp    | 16                        | Str 13   | Disadvantage | 55 lb. |
| Splint           | 200 gp   | 17                        | Str 15   | Disadvantage | 60 lb. |
| Plate            | 1,500 gp | 18                        | Str 15   | Disadvantage | 65 lb. |
| Shield           |          |                           |          |              |        |
| Shield           | 10 gp    | +2                        | -        | -            | 6 lb.  |
|                  |          |                           |          |              |        |

### Getting Into and Out of Armor

The time it takes to don or doff armor depends on the armor's category.

***Don***. This is the time it takes to put on armor. You benefit from the armor's AC only if you take the full time to don the suit of armor.

***Doff***. This is the time it takes to take off armor. If you have help, reduce this time by half.

**Table- Donning and Doffing Armor**

| Category     | Don        | Doff      |
|--------------|------------|-----------|
| Light Armor  | 1 minute   | 1 minute  |
| Medium Armor | 5 minutes  | 1 minute  |
| Heavy Armor  | 10 minutes | 5 minutes |
| Shield       | 1 action   | 1 action  |
|              |            |           |

## Coinage

Common coins come in several different denominations based on the relative worth of the metal from which they are made. The three most common coins are the gold piece (gp), the silver piece (sp), and the copper piece (cp).

With one gold piece, a character can buy a bedroll, 50 feet of good rope, or a goat. A skilled (but not exceptional) artisan can earn one gold piece a day. The old piece is the standard unit of measure for wealth, even if the coin itself is not commonly used. When merchants discuss deals that involve goods or services worth hundreds or thousands of gold pieces, the transactions don't usually involve the exchange of individual coins. Rather, the gold piece is a standard measure of value, and the actual exchange is in gold bars, letters of credit, or valuable goods.

One gold piece is worth ten silver pieces, the most prevalent coin among commoners. A silver piece buys a laborer's work for half a day, a flask of lamp oil, or a night's rest in a poor inn.

One silver piece is worth ten copper pieces, which are common among laborers and beggars. A single copper piece buys a candle, a torch, or a piece of chalk.

In addition, unusual coins made of other precious metals sometimes appear in treasure hoards. The electrum piece (ep) and the platinum piece (pp) originate from fallen empires and lost kingdoms, and they sometimes arouse suspicion and skepticism when used in transactions. An electrum piece is worth five silver pieces, and a platinum piece is worth ten gold pieces.

A standard coin weighs about a third of an ounce, so fifty coins weigh a pound.

## Expenses

When not descending into the depths of the earth, exploring ruins for lost treasures, or waging war against the encroaching darkness, adventurers face more mundane realities. Even in a fantastical world, people require basic necessities such as shelter, sustenance, and clothing. These things cost money, although some lifestyles cost more than others.

### Lifestyle Expenses

Lifestyle expenses provide you with a simple way to account for the cost of living in a fantasy world. They cover your accommodations, food and drink, and all your other necessities. Furthermore, expenses cover the cost of maintaining your equipment so you can be ready when adventure next calls.

At the start of each week or month (your choice), choose a lifestyle from the Expenses table and pay the price to sustain that lifestyle. The prices listed are per day, so if you wish to calculate the cost of your chosen lifestyle over a thirty-day period, multiply the listed price by 30. Your lifestyle might change from one period to the next, based on the funds you have at your disposal, or you might maintain the same lifestyle throughout your character's career.

Your lifestyle choice can have consequences. Maintaining a wealthy lifestyle might help you make contacts with the rich and powerful, though you run the risk of attracting thieves. Likewise, living frugally might help you avoid criminals, but you are unlikely to make powerful connections.

**Table- Lifestyle Expenses**

| Lifestyle    | Price/Day     |
|--------------|---------------|
| Wretched     | -             |
| Squalid      | 1 sp          |
| Poor         | 2 sp          |
| Modest       | 1 gp          |
| Comfortable  | 2 gp          |
| Wealthy      | 4 gp          |
| Aristocratic | 10 gp minimum |
|              |               |

***Wretched***. You live in inhumane conditions. With no place to call home, you shelter wherever you can, sneaking into barns, huddling in old crates, and relying on the good graces of people better off than you. A wretched lifestyle presents abundant dangers. Violence, disease, and hunger follow you wherever you go. Other wretched people covet your armor, weapons, and adventuring gear, which represent a fortune by their standards. You are beneath the notice of most people.

***Squalid***. You live in a leaky stable, a mud-floored hut just outside town, or a vermin-infested boarding house in the worst part of town. You have shelter from the elements, but you live in a desperate and often violent environment, in places rife with disease, hunger, and misfortune. You are beneath the notice of most people, and you have few legal protections. Most people at this lifestyle level have suffered some terrible setback. They might be disturbed, marked as exiles, or suffer from disease.

***Poor***. A poor lifestyle means going without the comforts available in a stable community. Simple food and lodgings, threadbare clothing, and unpredictable conditions result in a sufficient, though probably unpleasant, experience. Your accommodations might be a room in a flophouse or in the common room above a tavern. You benefit from some legal protections, but you still have to contend with violence, crime, and disease. People at this lifestyle level tend to be unskilled laborers, costermongers, peddlers, thieves, mercenaries, and other disreputable types.

***Modest***. A modest lifestyle keeps you out of the slums and ensures that you can maintain your equipment. You live in an older part of town, renting a room in a boarding house, inn, or temple. You don't go hungry or thirsty, and your living conditions are clean, if simple. Ordinary people living modest lifestyles include soldiers with families, laborers, students, priests, hedge wizards, and the like.

***Comfortable***. Choosing a comfortable lifestyle means that you can afford nicer clothing and can easily maintain your equipment. You live in a small cottage in a middle-class neighborhood or in a private room at a fine inn. You associate with merchants, skilled tradespeople, and military officers.

***Wealthy***. Choosing a wealthy lifestyle means living a life of luxury, though you might not have achieved the social status associated with the old money of nobility or royalty. You live a lifestyle comparable to that of a highly successful merchant, a favored servant of the royalty, or the owner of a few small businesses. You have respectable lodgings, usually a spacious home in a good part of town or a comfortable suite at a fine inn. You likely have a small staff of servants.

***Aristocratic***. You live a life of plenty and comfort. You move in circles populated by the most powerful people in the community. You have excellent lodgings, perhaps a townhouse in the nicest part of town or rooms in the finest inn. You dine at the best restaurants, retain the most skilled and fashionable tailor, and have servants attending to your every need. You receive invitations to the social gatherings of the rich and powerful, and spend evenings in the company of politicians, guild leaders, high priests, and nobility. You must also contend with the highest levels of deceit and treachery. The wealthier you are, the greater the chance you will be drawn into political intrigue as a pawn or participant.

### Food, Drink, and Lodging

The Food, Drink, and Lodging table gives prices for individual food items and a single night's lodging. These prices are included in your total lifestyle expenses.

**Table- Food, Drink, and Lodging**

| Item                   | Cost  |
|------------------------|-------|
| *Ale*                  |       |
| ~ Gallon               | 2 sp  |
| ~ Mug                  | 4 cp  |
| Banquet (per person)   | 10 gp |
| Bread, loaf            | 2 cp  |
| Cheese, hunk           | 1 sp  |
| *Inn stay (per day)*   |       |
| ~ Squalid              | 7 cp  |
| ~ Poor                 | 1 sp  |
| ~ Modest               | 5 sp  |
| ~ Comfortable          | 8 sp  |
| ~ Wealthy              | 2 gp  |
| ~ Aristocratic         | 4 gp  |
| *Meals (per day)*      |       |
| ~ Squalid              | 3 cp  |
| ~ Poor                 | 6 cp  |
| ~ Modest               | 3 sp  |
| ~ Comfortable          | 5 sp  |
| ~ Wealthy              | 8 sp  |
| ~ Aristocratic         | 2 gp  |
| Meat, chunk            | 3 sp  |
| *Wine*                 |       |
| ~ Common (pitcher)     | 2 sp  |
| ~ Fine (bottle)        | 10 gp |
|                        |       |

**Self-Sufficiency**

The expenses and lifestyles described here assume that you are spending your time between adventures in town, availing yourself of whatever services you can afford-paying for food and shelter, paying townspeople to sharpen your sword and repair your armor, and so on. Some characters, though, might prefer to spend their time away from civilization, sustaining themselves in the wild by hunting, foraging, and repairing their own gear.

Maintaining this kind of lifestyle doesn't require you to spend any coin, but it is time-consuming. If you spend your time between adventures practicing a profession, you can eke out the equivalent of a poor lifestyle. Proficiency in the Survival skill lets you live at the equivalent of a comfortable lifestyle.

### Services

Adventurers can pay nonplayer characters to assist them or act on their behalf in a variety of circumstances. Most such hirelings have fairly ordinary skills, while others are masters of a craft or art, and a few are experts with specialized adventuring skills.

Some of the most basic types of hirelings appear on the Services table. Other common hirelings include any of the wide variety of people who inhabit a typical town or city, when the adventurers pay them to perform a specific task. For example, a wizard might pay a carpenter to construct an elaborate chest (and its miniature replica) for use in the *secret chest* spell. A fighter might commission a blacksmith to forge a special sword. A bard might pay a tailor to make exquisite clothing for an upcoming performance in front of the duke.

Other hirelings provide more expert or dangerous services. Mercenary soldiers paid to help the adventurers take on a hobgoblin army are hirelings, as are sages hired to research ancient or esoteric lore. If a high-level adventurer establishes a stronghold of some kind, he or she might hire a whole staff of servants and agents to run the place, from a castellan or steward to menial laborers to keep the stables clean. These hirelings often enjoy a long-term contract that includes a place to live within the stronghold as part of the offered compensation.

Skilled hirelings include anyone hired to perform a service that involves a proficiency (including weapon, tool, or skill): a mercenary, artisan, scribe, and so on. The pay shown is a minimum; some expert hirelings require more pay. Untrained hirelings are hired for menial work that requires no particular skill and can include laborers, porters, maids, and similar workers.

**Table- Services**

| Service Pay       | Pay           |
|-------------------|---------------|
| *Coach cab*       |               |
| ~ Between towns   | 3 cp per mile |
| ~ Within a city   | 1 cp          |
| *Hireling*        |               |
| ~ Skilled         | 2 gp per day  |
| ~ Untrained       | 2 sp per day  |
| Messenger         | 2 cp per mile |
| Road or gate toll | 1 cp          |
| Ship's passage    | 1 sp per mile |
|                   |               |

### Spellcasting Services

People who are able to cast spells don't fall into the category of ordinary hirelings. It might be possible to find someone willing to cast a spell in exchange for coin or favors, but it is rarely easy and no established pay rates exist. As a rule, the higher the level of the desired spell, the harder it is to find someone who can cast it and the more it costs.

Hiring someone to cast a relatively common spell of 1st or 2nd level, such as *cure wounds* or *identify*, is easy enough in a city or town, and might cost 10 to 50 gold pieces (plus the cost of any expensive material components). Finding someone able and willing to cast a higher-level spell might involve traveling to a large city, perhaps one with a university or prominent temple. Once found, the spellcaster might ask for a service instead of payment-the kind of service that only adventurers can provide, such as retrieving a rare item from a dangerous locale or traversing a monster-infested wilderness to deliver something important to a distant settlement.


**Table- Standard Exchange Rates**

| Coin          | CP    | SP   | EP   | GP    | PP      |
|---------------|-------|------|------|-------|---------|
| Copper (cp)   | 1     | 1/10 | 1/50 | 1/100 | 1/1,000 |
| Silver (sp)   | 10    | 1    | 1/5  | 1/10  | 1/100   |
| Electrum (ep) | 50    | 5    | 1    | 1/2   | 1/20    |
| Gold (gp)     | 100   | 10   | 2    | 1     | 1/10    |
| Platinum (pp) | 1,000 | 100  | 20   | 10    | 1       |
|               |       |      |      |       |         |

## Adventuring Gear

This section describes items that have special rules or require further explanation.

***Acid***. As an action, you can splash the contents of this vial onto a creature within 5 feet of you or throw the vial up to 20 feet, shattering it on impact. In either case, make a ranged attack against a creature or object, treating the acid as an improvised weapon. On a hit, the target takes 2d6 acid damage.

***Alchemist's Fire***. This sticky, adhesive fluid ignites when exposed to air. As an action, you can throw this flask up to 20 feet, shattering it on impact. Make a ranged attack against a creature or object, treating the alchemist's fire as an improvised weapon. On a hit, the target takes 1d4 fire damage at the start of each of its turns. A creature can end this damage by using its action to make a DC 10 Dexterity check to extinguish the flames.

***Antitoxin***. A creature that drinks this vial of liquid gains advantage on saving throws against poison for 1 hour. It confers no benefit to undead or constructs.

***Arcane Focus***. An arcane focus is a special item-an orb, a crystal, a rod, a specially constructed staff, a wand-like length of wood, or some similar item- designed to channel the power of arcane spells. A sorcerer, warlock, or wizard can use such an item as a spellcasting focus.

***Ball Bearings***. As an action, you can spill these tiny metal balls from their pouch to cover a level, square area that is 10 feet on a side. A creature moving across the covered area must succeed on a DC 10 Dexterity saving throw or fall prone. A creature moving through the area at half speed doesn't need to make the save.

***Block and Tackle***. A set of pulleys with a cable threaded through them and a hook to attach to objects, a block and tackle allows you to hoist up to four times the weight you can normally lift.

***Book***. A book might contain poetry, historical accounts, information pertaining to a particular field of lore, diagrams and notes on gnomish contraptions, or just about anything else that can be represented using text or pictures. A book of spells is a spellbook (described later in this section).

***Caltrops***. As an action, you can spread a bag of caltrops to cover a square area that is 5 feet on a side. Any creature that enters the area must succeed on a DC 15 Dexterity saving throw or stop moving this turn and take 1 piercing damage. Taking this damage reduces the creature's walking speed by 10 feet until the creature regains at least 1 hit point. A creature moving through the area at half speed doesn't need to make the save.

***Candle***. For 1 hour, a candle sheds bright light in a 5-foot radius and dim light for an additional 5 feet.

***Case, Crossbow Bolt***. This wooden case can hold up to twenty crossbow bolts.

***Case, Map or Scroll***. This cylindrical leather case can hold up to ten rolled-up sheets of paper or five rolled-up sheets of parchment.

***Chain***. A chain has 10 hit points. It can be burst with a successful DC 20 Strength check.

***Climber's Kit***. A climber's kit includes special pitons, boot tips, gloves, and a harness. You can use the climber's kit as an action to anchor yourself; when you do, you can't fall more than 25 feet from the point where you anchored yourself, and you can't climb more than 25 feet away from that point without undoing the anchor.

***Component Pouch***. A component pouch is a small, watertight leather belt pouch that has compartments to hold all the material components and other special items you need to cast your spells, except for those components that have a specific cost (as indicated in a spell's description).

***Crowbar***. Using a crowbar grants advantage to Strength checks where the crowbar's leverage can be applied.

***Druidic Focus***. A druidic focus might be a sprig of mistletoe or holly, a wand or scepter made of yew or another special wood, a staff drawn whole out of a living tree, or a totem object incorporating feathers, fur, bones, and teeth from sacred animals. A druid can use such an object as a spellcasting focus.

***Fishing Tackle***. This kit includes a wooden rod, silken line, corkwood bobbers, steel hooks, lead sinkers, velvet lures, and narrow netting. Healer's Kit. This kit is a leather pouch containing bandages, salves, and splints. The kit has ten uses. As an action, you can expend one use of the kit to stabilize a creature that has 0 hit points, without needing to make a Wisdom (Medicine) check.

***Holy Symbol***. A holy symbol is a representation of a god or pantheon. It might be an amulet depicting a symbol representing a deity, the same symbol carefully engraved or inlaid as an emblem on a shield, or a tiny box holding a fragment of a sacred relic. Appendix PH-B "Fantasy-Historical Pantheons" lists the symbols commonly associated with many gods in the multiverse. A cleric or paladin can use a holy symbol as a spellcasting focus. To use the symbol in this way, the caster must hold it in hand, wear it visibly, or bear it on a shield.

***Holy Water***. As an action, you can splash the contents of this flask onto a creature within 5 feet of you or throw it up to 20 feet, shattering it on impact. In either case, make a ranged attack against a target creature, treating the holy water as an improvised weapon. If the target is a fiend or undead, it takes 2d6 radiant damage. A cleric or paladin may create holy water by performing a special ritual. The ritual takes 1 hour to perform, uses 25 gp worth of powdered silver, and requires the caster to expend a 1st-level spell slot.

***Hunting Trap***. When you use your action to set it, this trap forms a saw-toothed steel ring that snaps shut when a creature steps on a pressure plate in the center. The trap is affixed by a heavy chain to an immobile object, such as a tree or a spike driven into the ground. A creature that steps on the plate must succeed on a DC 13 Dexterity saving throw or take 1d4 piercing damage and stop moving. Thereafter, until the creature breaks free of the trap, its movement is limited by the length of the chain (typically 3 feet long). A creature can use its action to make a DC 13 Strength check, freeing itself or another creature within its reach on a success. Each failed check deals 1 piercing damage to the trapped creature.

***Lamp***. A lamp casts bright light in a 15-foot radius and dim light for an additional 30 feet. Once lit, it burns for 6 hours on a flask (1 pint) of oil. Lantern, Bullseye. A bullseye lantern casts bright light in a 60-foot cone and dim light for an additional 60 feet. Once lit, it burns for 6 hours on a flask (1 pint) of oil. Lantern, Hooded. A hooded lantern casts bright light in a 30-foot radius and dim light for an additional 30 feet. Once lit, it burns for 6 hours on a flask (1 pint) of oil. As an action, you can lower the hood, reducing the light to dim light in a 5-foot radius.

***Lock***. A key is provided with the lock. Without the key, a creature proficient with thieves' tools can pick this lock with a successful DC 15 Dexterity check. Your GM may decide that better locks are available for higher prices.

***Magnifying Glass***. This lens allows a closer look at small objects. It is also useful as a substitute for flint and steel when starting fires. Lighting a fire with a magnifying glass requires light as bright as sunlight to focus, tinder to ignite, and about 5 minutes for the fire to ignite. A magnifying glass grants advantage on any ability check made to appraise or inspect an item that is small or highly detailed.

***Manacles***. These metal restraints can bind a Small or Medium creature. Escaping the manacles requires a successful DC 20 Dexterity check. Breaking them requires a successful DC 20 Strength check. Each set of manacles comes with one key. Without the key, a creature proficient with thieves' tools can pick the manacles' lock with a successful DC 15 Dexterity check. Manacles have 15 hit points.

***Mess Kit***. This tin box contains a cup and simple cutlery. The box clamps together, and one side can be used as a cooking pan and the other as a plate or shallow bowl.

***Oil***. Oil usually comes in a clay flask that holds 1 pint. As an action, you can splash the oil in this flask onto a creature within 5 feet of you or throw it up to 20 feet, shattering it on impact. Make a ranged attack against a target creature or object, treating the oil as an improvised weapon. On a hit, the target is covered in oil. If the target takes any fire damage before the oil dries (after 1 minute), the target takes an additional 5 fire damage from the burning oil. You can also pour a flask of oil on the ground to cover a 5-foot square area, provided that the surface is level. If lit, the oil burns for 2 rounds and deals 5 fire damage to any creature that enters the area or ends its turn in the area. A creature can take this damage only once per turn.

***Poison, Basic***. You can use the poison in this vial to coat one slashing or piercing weapon or up to three pieces of ammunition. Applying the poison takes an action. A creature hit by the poisoned weapon or ammunition must make a DC 10 Constitution saving throw or take 1d4 poison damage. Once applied, the poison retains potency for 1 minute before drying.

***Potion of Healing***. A character who drinks the magical red fluid in this vial regains 2d4 + 2 hit points. Drinking or administering a potion takes an action.

***Pouch***. A cloth or leather pouch can hold up to 20 sling bullets or 50 blowgun needles, among other things. A compartmentalized pouch for holding spell components is called a component pouch (described earlier in this section). Quiver. A quiver can hold up to 20 arrows. Ram, Portable. You can use a portable ram to break down doors. When doing so, you gain a +4 bonus on the Strength check. One other character can help you use the ram, giving you advantage on this check.

***Rations***. Rations consist of dry foods suitable for extended travel, including jerky, dried fruit, hardtack, and nuts.

***Rope***. Rope, whether made of hemp or silk, has 2 hit points and can be burst with a DC 17 Strength check.

***Scale, Merchant's***. A scale includes a small balance, pans, and a suitable assortment of weights up to 2 pounds. With it, you can measure the exact weight of small objects, such as raw precious metals or trade goods, to help determine their worth.

***Spellbook***. Essential for wizards, a spellbook is a leather-bound tome with 100 blank vellum pages suitable for recording spells.

***Spyglass***. Objects viewed through a spyglass are magnified to twice their size.

***Tent***. A simple and portable canvas shelter, a tent sleeps two.

***Tinderbox***. This small container holds flint, fire steel, and tinder (usually dry cloth soaked in light oil) used to kindle a fire. Using it to light a torch-or anything else with abundant, exposed fuel-takes an action. Lighting any other fire takes 1 minute.

***Torch***. A torch burns for 1 hour, providing bright light in a 20-foot radius and dim light for an additional 20 feet. If you make a melee attack with a burning torch and hit, it deals 1 fire damage.

**Equipment Packs**

The starting equipment you get from your class includes a collection of useful adventuring gear, put together in a pack. The contents of these packs are listed here. If you are buying your starting equipment, you can purchase a pack for the price shown, which might be cheaper than buying the items individually.

***Burglar's Pack (16 gp)***. Includes a backpack, a bag of 1,000 ball bearings, 10 feet of string, a bell, 5 candles, a crowbar, a hammer, 10 pitons, a hooded lantern, 2 flasks of oil, 5 days rations, a tinderbox, and a waterskin. The pack also has 50 feet of hempen rope strapped to the side of it.

***Diplomat's Pack (39 gp)***. Includes a chest, 2 cases for maps and scrolls, a set of fine clothes, a bottle of ink, an ink pen, a lamp, 2 flasks of oil, 5 sheets of paper, a vial of perfume, sealing wax, and soap.

***Dungeoneer's Pack (12 gp)***. Includes a backpack, a crowbar, a hammer, 10 pitons, 10 torches, a tinderbox, 10 days of rations, and a waterskin. The pack also has 50 feet of hempen rope strapped to the side of it.

***Entertainer's Pack (40 gp)***. Includes a backpack, a bedroll, 2 costumes, 5 candles, 5 days of rations, a waterskin, and a disguise kit.

***Explorer's Pack (10 gp)***. Includes a backpack, a bedroll, a mess kit, a tinderbox, 10 torches, 10 days of rations, and a waterskin. The pack also has 50 feet of hempen rope strapped to the side of it.

***Priest's Pack (19 gp)***. Includes a backpack, a blanket, 10 candles, a tinderbox, an alms box, 2 blocks of incense, a censer, vestments, 2 days of rations, and a waterskin.

***Scholar's Pack (40 gp)***. Includes a backpack, a book of lore, a bottle of ink, an ink pen, 10 sheets of parchment, a little bag of sand, and a small knife.

**Table- Adventuring Gear**

| Item                         | Cost     | Weight       |
|------------------------------|----------|--------------|
| Abacus                       | 2 gp     | 2 lb.        |
| Acid (vial)                  | 25 gp    | 1 lb.        |
| Alchemist's fire (flask)     | 50 gp    | 1 lb.        |
| *Ammunition*                 |          |              |
| ~ Arrows (20)                | 1 gp     | 1 lb.        |
| ~ Blowgun needles (50)       | 1 gp     | 1 lb.        |
| ~ Crossbow bolts (20)        | 1 gp     | 1½ lb.       |
| ~ Sling bullets (20)         | 4 cp     | 1½ lb.       |
| Antitoxin (vial)             | 50 gp    | -            |
| *Arcane focus*               |          |              |
| ~ Crystal                    | 10 gp    | 1 lb.        |
| ~ Orb                        | 20 gp    | 3 lb.        |
| ~ Rod                        | 10 gp    | 2 lb.        |
| ~ Staff                      | 5 gp     | 4 lb.        |
| ~ Wand                       | 10 gp    | 1 lb.        |
| Backpack                     | 2 gp     | 5 lb.        |
| Ball bearings (bag of 1,000) | 1 gp     | 2 lb.        |
| Barrel                       | 2 gp     | 70 lb.       |
| Basket                       | 4 sp     | 2 lb.        |
| Bedroll                      | 1 gp     | 7 lb.        |
| Bell                         | 1 gp     | -            |
| Blanket                      | 5 sp     | 3 lb.        |
| Block and tackle             | 1 gp     | 5 lb.        |
| Book                         | 25 gp    | 5 lb.        |
| Bottle, glass                | 2 gp     | 2 lb.        |
| Bucket                       | 5 cp     | 2 lb.        |
| Caltrops (bag of 20)         | 1 gp     | 2 lb.        |
| Candle                       | 1 cp     | -            |
| Case, crossbow bolt          | 1 gp     | 1 lb.        |
| Case, map or scroll          | 1 gp     | 1 lb.        |
| Chain (10 feet)              | 5 gp     | 10 lb.       |
| Chalk (1 piece)              | 1 cp     | -            |
| Chest                        | 5 gp     | 25 lb.       |
| Climber's kit                | 25 gp    | 12 lb.       |
| Clothes, common              | 5 sp     | 3 lb.        |
| Clothes, costume             | 5 gp     | 4 lb.        |
| Clothes, fine                | 15 gp    | 6 lb.        |
| Clothes, traveler's          | 2 gp     | 4 lb.        |
| Component pouch              | 25 gp    | 2 lb.        |
| Crowbar                      | 2 gp     | 5 lb.        |
| *Druidic focus*              |          |              |
| ~ Sprig of mistletoe         | 1 gp     | -            |
| ~ Totem                      | 1 gp     | -            |
| ~ Wooden staff               | 5 gp     | 4 lb.        |
| ~ Yew wand                   | 10 gp    | 1 lb.        |
| Fishing tackle               | 1 gp     | 4 lb.        |
| Flask or tankard             | 2 cp     | 1 lb.        |
| Grappling hook               | 2 gp     | 4 lb.        |
| Hammer                       | 1 gp     | 3 lb.        |
| Hammer, sledge               | 2 gp     | 10 lb.       |
| Healer's kit                 | 5 gp     | 3 lb.        |
| *Holy symbol*                |          |              |
| ~ Amulet                     | 5 gp     | 1 lb.        |
| ~ Emblem                     | 5 gp     | -            |
| ~ Reliquary                  | 5 gp     | 2 lb.        |
| Holy water (flask)           | 25 gp    | 1 lb.        |
| Hourglass                    | 25 gp    | 1 lb.        |
| Hunting trap                 | 5 gp     | 25 lb.       |
| Ink (1 ounce bottle)         | 10 gp    | -            |
| Ink pen                      | 2 cp     | -            |
| Jug or pitcher               | 2 cp     | 4 lb.        |
| Ladder (10-foot)             | 1 sp     | 25 lb.       |
| Lamp                         | 5 sp     | 1 lb.        |
| Lantern, bullseye            | 10 gp    | 2 lb.        |
| Lantern, hooded              | 5 gp     | 2 lb.        |
| Lock                         | 10 gp    | 1 lb.        |
| Magnifying glass             | 100 gp   | -            |
| Manacles                     | 2 gp     | 6 lb.        |
| Mess kit                     | 2 sp     | 1 lb.        |
| Mirror, steel                | 5 gp     | 1/2 lb.      |
| Oil (flask)                  | 1 sp     | 1 lb.        |
| Paper (one sheet)            | 2 sp     | -            |
| Parchment (one sheet)        | 1 sp     | -            |
| Perfume (vial)               | 5 gp     | -            |
| Pick, miner's                | 2 gp     | 10 lb.       |
| Piton                        | 5 cp     | 1/4 lb.      |
| Poison, basic (vial)         | 100 gp   | -            |
| Pole (10-foot)               | 5 cp     | 7 lb.        |
| Pot, iron                    | 2 gp     | 10 lb.       |
| Potion of healing 5          | 0 gp     | 1/2 lb.      |
| Pouch                        | 5 sp     | 1 lb.        |
| Quiver                       | 1 gp     | 1 lb.        |
| Ram, portable                | 4 gp     | 35 lb.       |
| Rations (1 day)              | 5 sp     | 2 lb.        |
| Robes                        | 1 gp     | 4 lb.        |
| Rope, hempen (50 feet)       | 1 gp     | 10 lb.       |
| Rope, silk (50 feet)         | 10 gp    | 5 lb.        |
| Sack                         | 1 cp     | 1/2 lb.      |
| Scale, merchant's            | 5 gp     | 3 lb.        |
| Sealing wax                  | 5 sp     | -            |
| Shovel                       | 2 gp     | 5 lb.        |
| Signal whistle               | 5 cp     | -            |
| Signet ring                  | 5 gp     | -            |
| Soap                         | 2 cp     | -            |
| Spellbook                    | 50 gp    | 3 lb.        |
| Spikes, iron (10)            | 1 gp     | 5 lb.        |
| Spyglass                     | 1,000 gp | 1 lb.        |
| Tent, two-person             | 2 gp     | 20 lb.       |
| Tinderbox                    | 5 sp     | 1 lb.        |
| Torch                        | 1 cp     | 1 lb.        |
| Vial                         | 1 gp     | -            |
| Waterskin                    | 2 sp     | 5 lb. (full) |
| Whetstone                    | 1 cp     | 1 lb.        |
|                              |          |              |

**Table- Container Capacity**

| Container        | Capacity                               |
|------------------|----------------------------------------|
| Backpack*        | 1 cubic foot/30 pounds of gear         |
| Barrel           | 40 gallons liquid, 4 cubic feet solid  |
| Basket           | 2 cubic feet/40 pounds of gear         |
| Bottle           | 1½ pints liquid                        |
| Bucket           | 3 gallons liquid, 1/2 cubic foot solid |
| Chest            | 12 cubic feet/300 pounds of gear       |
| Flask or tankard | 1 pint liquid                          |
| Jug or pitcher   | 1 gallon liquid                        |
| Pot, iron        | 1 gallon liquid                        |
| Pouch            | 1/5 cubic foot/6 pounds of gear        |
| Sack             | 1 cubic foot/30 pounds of gear         |
| Vial             | 4 ounces liquid                        |
| Waterskin        | 4 pints liquid                         |
|                  |                                        |

\* You can also strap items, such as a bedroll or a coil of rope, to the outside of a backpack.

## Selling Treasure

Opportunities abound to find treasure, equipment, weapons, armor, and more in the dungeons you explore. Normally, you can sell your treasures and trinkets when you return to a town or other settlement, provided that you can find buyers and merchants interested in your loot.

***Arms, Armor, and Other Equipment***. As a general rule, undamaged weapons, armor, and other equipment fetch half their cost when sold in a market. Weapons and armor used by monsters are rarely in good enough condition to sell.

***Magic Items***. Selling magic items is problematic. Finding someone to buy a potion or a scroll isn't too hard, but other items are out of the realm of most but the wealthiest nobles. Likewise, aside from a few common magic items, you won't normally come across magic items or spells to purchase. The value of magic is far beyond simple gold and should always be treated as such.

***Gems, Jewelry, and Art Objects***. These items retain their full value in the marketplace, and you can either trade them in for coin or use them as currency for other transactions. For exceptionally valuable treasures, the GM might require you to find a buyer in a large town or larger community first.

***Trade Goods***. On the borderlands, many people conduct transactions through barter. Like gems and art objects, trade goods-bars of iron, bags of salt, livestock, and so on-retain their full value in the market and can be used as currency.

## Tools

A tool helps you to do something you couldn't otherwise do, such as craft or repair an item, forge a document, or pick a lock. Your race, class, background, or feats give you proficiency with certain tools. Proficiency with a tool allows you to add your proficiency bonus to any ability check you make using that tool. Tool use is not tied to a single ability, since proficiency with a tool represents broader knowledge of its use. For example, the GM might ask you to make a Dexterity check to carve a fine detail with your woodcarver's tools, or a Strength check to make something out of particularly hard wood.

**Table- Tools**

| Item                      | Cost  | Weight |
|---------------------------|-------|--------|
| *Artisan's tools*         |       |        |
| ~ Alchemist's supplies    | 50 gp | 8 lb.  |
| ~ Brewer's supplies       | 20 gp | 9 lb.  |
| ~ Calligrapher's supplies | 10 gp | 5 lb.  |
| ~ Carpenter's tools       | 8 gp  | 6 lb.  |
| ~ Cartographer's tools    | 15 gp | 6 lb.  |
| ~ Cobbler's tools         | 5 gp  | 5 lb.  |
| ~ Cook's utensils         | 1 gp  | 8 lb.  |
| ~ Glassblower's tools     | 30 gp | 5 lb.  |
| ~ Jeweler's tools         | 25 gp | 2 lb.  |
| ~ Leatherworker's tools   | 5 gp  | 5 lb.  |
| ~ Mason's tools           | 10 gp | 8 lb.  |
| ~ Painter's supplies      | 10 gp | 5 lb.  |
| ~ Potter's tools          | 10 gp | 3 lb.  |
| ~ Smith's tools           | 20 gp | 8 lb.  |
| ~ Tinker's tools          | 50 gp | 10 lb. |
| ~ Weaver's tools          | 1 gp  | 5 lb.  |
| ~ Woodcarver's tools      | 1 gp  | 5 lb.  |
| Disguise kit              | 25 gp | 3 lb.  |
| Forgery kit               | 15 gp | 5 lb.  |
| *Gaming set*              |       |        |
| ~ Dice set                | 1 sp  | -      |
| ~ Playing card set        | 5 sp  | -      |
| Herbalism kit             | 5 gp  | 3 lb.  |
| *Musical instrument*      |       |        |
| ~ Bagpipes                | 30 gp | 6 lb.  |
| ~ Drum                    | 6 gp  | 3 lb.  |
| ~ Dulcimer                | 25 gp | 10 lb. |
| ~ Flute                   | 2 gp  | 1 lb.  |
| ~ Lute                    | 35 gp | 2 lb.  |
| ~ Lyre                    | 30 gp | 2 lb.  |
| ~ Horn                    | 3 gp  | 2 lb.  |
| ~ Pan flute               | 12 gp | 2 lb.  |
| ~ Shawm                   | 2 gp  | 1 lb.  |
| ~ Viol                    | 30 gp | 1 lb.  |
| Navigator's tools         | 25 gp | 2 lb.  |
| Poisoner's kit            | 50 gp | 2 lb.  |
| Thieves' tools            | 25 gp | 1 lb.  |
| Vehicles (land or water)  | *     | *      |
|                           |       |        |

\* See the "Mounts and Vehicles" section.

***Artisan's Tools***. These special tools include the items needed to pursue a craft or trade. The table shows examples of the most common types of tools, each providing items related to a single craft. Proficiency with a set of artisan's tools lets you add your proficiency bonus to any ability checks you make using the tools in your craft. Each type of artisan's tools requires a separate proficiency.

***Disguise Kit***. This pouch of cosmetics, hair dye, and small props lets you create disguises that change your physical appearance. Proficiency with this kit lets you add your proficiency bonus to any ability checks you make to create a visual disguise.

***Forgery Kit***. This small box contains a variety of papers and parchments, pens and inks, seals and sealing wax, gold and silver leaf, and other supplies necessary to create convincing forgeries of physical documents. Proficiency with this kit lets you add your proficiency bonus to any ability checks you make to create a physical forgery of a document.

***Gaming Set***. This item encompasses a wide range of game pieces, including dice and decks of cards (for games such as Three-Dragon Ante). A few common examples appear on the Tools table, but other kinds of gaming sets exist. If you are proficient with a gaming set, you can add your proficiency bonus to ability checks you make to play a game with that set. Each type of gaming set requires a separate proficiency.

***Herbalism Kit***. This kit contains a variety of instruments such as clippers, mortar and pestle, and pouches and vials used by herbalists to create remedies and potions. Proficiency with this kit lets you add your proficiency bonus to any ability checks you make to identify or apply herbs. Also, proficiency with this kit is required to create antitoxin and potions of healing.

***Musical Instrument***. Several of the most common types of musical instruments are shown on the table as examples. If you have proficiency with a given musical instrument, you can add your proficiency bonus to any ability checks you make to play music with the instrument. A bard can use a musical instrument as a spellcasting focus. Each type of musical instrument requires a separate proficiency.

***Navigator's Tools***. This set of instruments is used for navigation at sea. Proficiency with navigator's tools lets you chart a ship's course and follow navigation charts. In addition, these tools allow you to add your proficiency bonus to any ability check you make to avoid getting lost at sea.

***Poisoner's Kit***. A poisoner's kit includes the vials, chemicals, and other equipment necessary for the creation of poisons. Proficiency with this kit lets you add your proficiency bonus to any ability checks you make to craft or use poisons.

***Thieves' Tools***. This set of tools includes a small file, a set of lock picks, a small mirror mounted on a metal handle, a set of narrow-bladed scissors, and a pair of pliers. Proficiency with these tools lets you add your proficiency bonus to any ability checks you make to disarm traps or open locks.

## Trade Goods

Most wealth is not in coins. It is measured in livestock, grain, land, rights to collect taxes, or rights to resources (such as a mine or a forest).

Guilds, nobles, and royalty regulate trade. Chartered companies are granted rights to conduct trade along certain routes, to send merchant ships to various ports, or to buy or sell specific goods. Guilds set prices for the goods or services that they control, and determine who may or may not offer those goods and services. Merchants commonly exchange trade goods without using currency. The Trade Goods table shows the value of commonly exchanged goods.

**Table- Cost of Trade Goods**

| Cost   | Goods                                        |
|--------|----------------------------------------------|
| 1 cp   | 1 lb. of wheat                               |
| 2 cp   | 1 lb. of flour or one chicken                |
| 5 cp   | 1 lb. of salt                                |
| 1 sp   | 1 lb. of iron or 1 sq. yd. of canvas         |
| 5 sp   | 1 lb. of copper or 1 sq. yd. of cotton cloth |
| 1 gp   | 1 lb. of ginger or one goat                  |
| 2 gp   | 1 lb. of cinnamon or pepper, or one sheep    |
| 3 gp   | 1 lb. of cloves or one pig                   |
| 5 gp   | 1 lb. of silver or 1 sq. yd. of linen        |
| 10 gp  | 1 sq. yd. of silk or one cow                 |
| 15 gp  | 1 lb. of saffron or one ox                   |
| 50 gp  | 1 lb. of gold                                |
| 500 gp | 1 lb. of platinum                            |
|        |                                              |

## Mounts and Vehicles

A good mount can help you move more quickly through the wilderness, but its primary purpose is to carry the gear that would otherwise slow you down. The Mounts and Other Animals table shows each animal's speed and base carrying capacity.

An animal pulling a carriage, cart, chariot, sled, or wagon can move weight up to five times its base carrying capacity, including the weight of the vehicle. If multiple animals pull the same vehicle, they can add their carrying capacity together.

Mounts other than those listed here are available in fantasy gaming worlds, but they are rare and not normally available for purchase. These include flying mounts (pegasi, griffons, hippogriffs, and similar animals) and even aquatic mounts (giant sea horses, for example). Acquiring such a mount often means securing an egg and raising the creature yourself, making a bargain with a powerful entity, or negotiating with the mount itself.

***Barding***. Barding is armor designed to protect an animal's head, neck, chest, and body. Any type of armor shown on the Armor table can be purchased as barding. The cost is four times the equivalent armor made for humanoids, and it weighs twice as much.

***Saddles***. A military saddle braces the rider, helping you keep your seat on an active mount in battle. It gives you advantage on any check you make to remain mounted. An exotic saddle is required for riding any aquatic or flying mount.

***Vehicle Proficiency***. If you have proficiency with a certain kind of vehicle (land or water), you can add your proficiency bonus to any check you make to control that kind of vehicle in difficult circumstances.

***Rowed Vessels***. Keelboats and rowboats are used on lakes and rivers. If going downstream, add the speed of the current (typically 3 miles per hour) to the speed of the vehicle. These vehicles can't be rowed against any significant current, but they can be pulled upstream by draft animals on the shores. A rowboat weighs 100 pounds, in case adventurers carry it over land.

**Table- Mounts and Other Animals**

| Item           | Cost   | Speed  | Carrying Capacity |
|----------------|--------|--------|-------------------|
| Camel          | 50 gp  | 50 ft. | 480 lb.           |
| Donkey or mule | 8 gp   | 40 ft. | 420 lb.           |
| Elephant       | 200 gp | 40 ft. | 1,320 lb.         |
| Horse, draft   | 50 gp  | 40 ft. | 540 lb.           |
| Horse, riding  | 75 gp  | 60 ft. | 480 lb.           |
| Mastiff        | 25 gp  | 40 ft. | 195 lb.           |
| Pony           | 30 gp  | 40 ft. | 225 lb.           |
| Warhorse       | 400 gp | 60 ft. | 540 lb.           |
|                |        |        |                   |

**Table- Tack, Harness, and Drawn Vehicles**

| Item               | Cost   | Weight  |
|--------------------|--------|---------|
| Barding            | ×4     | ×2      |
| Bit and bridle     | 2 gp   | 1 lb.   |
| Carriage           | 100 gp | 600 lb. |
| Cart               | 15 gp  | 200 lb. |
| Chariot            | 250 gp | 100 lb. |
| Feed (per day)     | 5 cp   | 10 lb.  |
| *Saddle*           |        |         |
| ~ Exotic           | 60 gp  | 40 lb.  |
| ~ Military         | 20 gp  | 30 lb.  |
| ~ Pack             | 5 gp   | 15 lb.  |
| ~ Riding           | 10 gp  | 25 lb.  |
| Saddlebags         | 4 gp   | 8 lb.   |
| Sled               | 20 gp  | 300 lb. |
| Stabling (per day) | 5 sp   | -       |
| Wagon              | 35 gp  | 400 lb. |
|                    |        |         |

**Table- Waterborne Vehicles**

| Item         | Cost      | Speed  |
|--------------|-----------|--------|
| Galley       | 30,000 gp | 4 mph  |
| Keelboat     | 3,000 gp  | 1 mph  |
| Longship     | 10,000 gp | 3 mph  |
| Rowboat      | 50 gp     | 1½ mph |
| Sailing ship | 10,000 gp | 2 mph  |
| Warship      | 25,000 gp | 2½ mph |
|              |           |        |

## Weapons

Your class grants proficiency in certain weapons, reflecting both the class's focus and the tools you are most likely to use. Whether you favor a longsword or a longbow, your weapon and your ability to wield it effectively can mean the difference between life and death while adventuring.

The Weapons table shows the most common weapons used in the fantasy gaming worlds, their price and weight, the damage they deal when they hit, and any special properties they possess. Every weapon is classified as either melee or ranged. A **melee weapon** is used to attack a target within 5 feet of you, whereas a **ranged weapon** is used to attack a target at a distance.

### Weapon Proficiency

Your race, class, and feats can grant you proficiency with certain weapons or categories of weapons. The two categories are **simple** and **martial**. Most people can use simple weapons with proficiency. These weapons include clubs, maces, and other weapons often found in the hands of commoners. Martial weapons, including swords, axes, and polearms, require more specialized training to use effectively. Most warriors use martial weapons because these weapons put their fighting style and training to best use.

Proficiency with a weapon allows you to add your proficiency bonus to the attack roll for any attack you make with that weapon. If you make an attack roll using a weapon with which you lack proficiency, you do not add your proficiency bonus to the attack roll.

### Weapon Properties

Many weapons have special properties related to their use, as shown in the Weapons table.

***Ammunition***. You can use a weapon that has the ammunition property to make a ranged attack only if you have ammunition to fire from the weapon. Each time you attack with the weapon, you expend one piece of ammunition. Drawing the ammunition from a quiver, case, or other container is part of the attack (you need a free hand to load a one-handed weapon). At the end of the battle, you can recover half your expended ammunition by taking a minute to search the battlefield.

If you use a weapon that has the ammunition property to make a melee attack, you treat the weapon as an improvised weapon (see "Improvised Weapons" later in the section). A sling must be loaded to deal any damage when used in this way.

***Finesse***. When making an attack with a finesse weapon, you use your choice of your Strength or Dexterity modifier for the attack and damage rolls. You must use the same modifier for both rolls.

***Heavy***. Small creatures have disadvantage on attack rolls with heavy weapons. A heavy weapon's size and bulk make it too large for a Small creature to use effectively.

***Light***. A light weapon is small and easy to handle, making it ideal for use when fighting with two weapons.

***Loading***. Because of the time required to load this weapon, you can fire only one piece of ammunition from it when you use an action, bonus action, or reaction to fire it, regardless of the number of attacks you can normally make.

***Range***. A weapon that can be used to make a ranged attack has a range in parentheses after the ammunition or thrown property. The range lists two numbers. The first is the weapon's normal range in feet, and the second indicates the weapon's long range. When attacking a target beyond normal range, you have disadvantage on the attack roll. You can't attack a target beyond the weapon's long range.

***Reach***. This weapon adds 5 feet to your reach when you attack with it, as well as when determining your reach for opportunity attacks with it.

***Special***. A weapon with the special property has unusual rules governing its use, explained in the weapon's description (see "Special Weapons" later in this section).

***Thrown***. If a weapon has the thrown property, you can throw the weapon to make a ranged attack. If the weapon is a melee weapon, you use the same ability modifier for that attack roll and damage roll that you would use for a melee attack with the weapon. For example, if you throw a handaxe, you use your Strength, but if you throw a dagger, you can use either your Strength or your Dexterity, since the dagger has the finesse property.

***Two-Handed***. This weapon requires two hands when you attack with it.

***Versatile***. This weapon can be used with one or two hands. A damage value in parentheses appears with the property-the damage when the weapon is used with two hands to make a melee attack.

#### Improvised Weapons

Sometimes characters don't have their weapons and have to attack with whatever is at hand. An improvised weapon includes any object you can wield in one or two hands, such as broken glass, a table leg, a frying pan, a wagon wheel, or a dead goblin.

Often, an improvised weapon is similar to an actual weapon and can be treated as such. For example, a table leg is akin to a club. At the GM's option, a character proficient with a weapon can use a similar object as if it were that weapon and use his or her proficiency bonus.

An object that bears no resemblance to a weapon deals 1d4 damage (the GM assigns a damage type appropriate to the object). If a character uses a ranged weapon to make a melee attack, or throws a melee weapon that does not have the thrown property, it also deals 1d4 damage. An improvised thrown weapon has a normal range of 20 feet and a long range of 60 feet.

#### Silvered Weapons

Some monsters that have immunity or resistance to nonmagical weapons are susceptible to silver weapons, so cautious adventurers invest extra coin to plate their weapons with silver. You can silver a single weapon or ten pieces of ammunition for 100 gp. This cost represents not only the price of the silver, but the time and expertise needed to add silver to the weapon without making it less effective.

#### Special Weapons

Weapons with special rules are described here.

***Lance***. You have disadvantage when you use a lance to attack a target within 5 feet of you. Also, a lance requires two hands to wield when you aren't mounted.

***Net***. A Large or smaller creature hit by a net is restrained until it is freed. A net has no effect on creatures that are formless, or creatures that are Huge or larger. A creature can use its action to make a DC 10 Strength check, freeing itself or another creature within its reach on a success. Dealing 5 slashing damage to the net (AC 10) also frees the creature without harming it, ending the effect and destroying the net.

When you use an action, bonus action, or reaction to attack with a net, you can make only one attack regardless of the number of attacks you can normally make.

**Table- Weapons**

| Name                       | Cost  | Damage          | Weight  | Properties                                             |
|----------------------------|-------|-----------------|---------|--------------------------------------------------------|
| **Simple Melee Weapons**   |       |                 |         |                                                        |
| Club                       | 1 sp  | 1d4 bludgeoning | 2 lb.   | Light                                                  |
| Dagger                     | 2 gp  | 1d4 piercing    | 1 lb.   | Finesse, light, thrown (range 20/60)                   |
| Greatclub                  | 2 sp  | 1d8 bludgeoning | 10 lb.  | Two-handed                                             |
| Handaxe                    | 5 gp  | 1d6 slashing    | 2 lb.   | Light, thrown (range 20/60)                            |
| Javelin                    | 5 sp  | 1d6 piercing    | 2 lb.   | Thrown (range 30/120)                                  |
| Light hammer               | 2 gp  | 1d4 bludgeoning | 2 lb.   | Light, thrown (range 20/60)                            |
| Mace                       | 5 gp  | 1d6 bludgeoning | 4 lb.   | -                                                      |
| Quarterstaff               | 2 sp  | 1d6 bludgeoning | 4 lb.   | Versatile (1d8)                                        |
| Sickle                     | 1 gp  | 1d4 slashing    | 2 lb.   | Light                                                  |
| Spear                      | 1 gp  | 1d6 piercing    | 3 lb.   | Thrown (range 20/60), versatile (1d8)                  |
| **Simple Ranged Weapons**  |       |                 |         |                                                        |
| Crossbow, light            | 25 gp | 1d8 piercing    | 5 lb.   | Ammunition (range 80/320), loading, two-handed         |
| Dart                       | 5 cp  | 1d4 piercing    | 1/4 lb. | Finesse, thrown (range 20/60)                          |
| Shortbow                   | 25 gp | 1d6 piercing    | 2 lb.   | Ammunition (range 80/320), two-handed                  |
| Sling                      | 1 sp  | 1d4 bludgeoning | -       | Ammunition (range 30/120)                              |
| **Martial Melee Weapons**  |       |                 |         |                                                        |
| Battleaxe                  | 10 gp | 1d8 slashing    | 4 lb.   | Versatile (1d10)                                       |
| Flail                      | 10 gp | 1d8 bludgeoning | 2 lb.   | -                                                      |
| Glaive                     | 20 gp | 1d10 slashing   | 6 lb.   | Heavy, reach, two-handed                               |
| Greataxe                   | 30 gp | 1d12 slashing   | 7 lb.   | Heavy, two-handed                                      |
| Greatsword                 | 50 gp | 2d6 slashing    | 6 lb.   | Heavy, two-handed                                      |
| Halberd                    | 20 gp | 1d10 slashing   | 6 lb.   | Heavy, reach, two-handed                               |
| Lance                      | 10 gp | 1d12 piercing   | 6 lb.   | Reach, special                                         |
| Longsword                  | 15 gp | 1d8 slashing    | 3 lb.   | Versatile (1d10)                                       |
| Maul                       | 10 gp | 2d6 bludgeoning | 10 lb.  | Heavy, two-handed                                      |
| Morningstar                | 15 gp | 1d8 piercing    | 4 lb.   | -                                                      |
| Pike                       | 5 gp  | 1d10 piercing   | 18 lb.  | Heavy, reach, two-handed                               |
| Rapier                     | 25 gp | 1d8 piercing    | 2 lb.   | Finesse                                                |
| Scimitar                   | 25 gp | 1d6 slashing    | 3 lb.   | Finesse, light                                         |
| Shortsword                 | 10 gp | 1d6 piercing    | 2 lb.   | Finesse, light                                         |
| Trident                    | 5 gp  | 1d6 piercing    | 4 lb.   | Thrown (range 20/60), versatile (1d8)                  |
| War pick                   | 5 gp  | 1d8 piercing    | 2 lb.   | -                                                      |
| Warhammer                  | 15 gp | 1d8 bludgeoning | 2 lb.   | Versatile (1d10)                                       |
| Whip                       | 2 gp  | 1d4 slashing    | 3 lb.   | Finesse, reach                                         |
| **Martial Ranged Weapons** |       |                 |         |                                                        |
| Blowgun                    | 10 gp | 1 piercing      | 1 lb.   | Ammunition (range 25/100), loading                     |
| Crossbow, hand             | 75 gp | 1d6 piercing    | 3 lb.   | Ammunition (range 30/120), light, loading              |
| Crossbow, heavy            | 50 gp | 1d10 piercing   | 18 lb.  | Ammunition (range 100/400), heavy, loading, two-handed |
| Longbow                    | 50 gp | 1d8 piercing    | 2 lb.   | Ammunition (range 150/600), heavy, two-handed          |
| Net                        | 1 gp  | -               | 3 lb.   | Special, thrown (range 5/15)                           |
|                            |       |                 |         |                                                        |
